 ; Ŀ
 ;   Bn - reposition text above a line.                                    
 ;   Copyright 2001 - 2007 by Rocket Software Ltd.                         
 ;   Nobody likes entropy, but everyone wants to be warm.                  
 ; 

 ; Ŀ
 ;   Subroutine Cstar - draw an individual grstar (centred).               
 ;   Takes four arguments: centre point, side length, rotation (radians),  
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN CSTAR (pa sidlen rota colo / anginc angg hafang pb)
  (setq pa (polar pa (+ rota (/ pi 2)) (* sidlen 1.37638192)))
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Cstar end.                                                 
 ; 

 ; Ŀ
 ;   Pspt - find the mid and endpoints of a line either in paper or        
 ;   model space.                                                          
 ;   Takes no arguments, calls nothing, collects stamps.                   
 ; 
 (DEFUN PSPT (/ pap pa papse papsm)
  (prompt "\nLine:")
 ; Ŀ
 ;   Get a point using a selection box so as not to upset the user.        
 ; 
  (if (and (setq pap (grread nil 4 2))
           (= (car pap) 3))
      (progn
           (setq pa (cadr pap))
 ; Ŀ
 ;   If there was an entity at that point get its data.                    
 ; 
           (setq papse (osnap pa "endpoint"))
           (setq papsm (osnap pa "midpoint"))))
 (list papse papsm))
 ; Ŀ
 ;   Pspt end.                                                             
 ; 

 ; Ŀ
 ;   Tbx - text extents locator and outliner.                              
 ; 
 (DEFUN TBX (enam / aa bb rota cc dd bheigt bwidth llangg lldist ll ul lr ur)
  (setq aa (entget enam))
 ; Ŀ
 ;   The textbox function returns...hang on...from the notes below, a      
 ;   list containing the offset of the lower left point of the text from   
 ;   the 10 association point - typically 0,0,0 - and the offset of the    
 ;   upper right point from the ten point.  These are assuming that the    
 ;   text isn't obliqued or rotated, so if it is the program must adjust   
 ;   accordingly.  This program won't bother with obliquing, rotation is   
 ;   allowed.                                                              
 ; 
  (setq bb (textbox aa))
  (setq rota (cdr (assoc 50 aa)))
  (setq cc (car bb))                    ; ll offset from 10 of text
  (setq dd (cadr bb))                   ; ur offset from 10 of text
  (setq bheigt (- (cadr dd) (cadr cc)))
  (setq bwidth (- (car dd) (car cc)))
  (setq llangg (angle (list 0 0) cc))
  (setq lldist (distance (list 0 0) cc))
  (setq ll (polar (cdr (assoc 10 aa)) (+ llangg rota) lldist))
  (setq ul (polar ll (+ rota (/ pi 2)) bheigt))
  (setq lr (polar ll rota bwidth))
  (setq ur (polar lr (+ rota (/ pi 2)) bheigt))
 ; Ŀ
 ;   We now have the real upper left, upper right, etc. points of the      
 ;   text.                                                                 
 ; 
  (if nil
      (progn
           (grdraw ll ul 150)
           (grdraw ul ur 150)
           (grdraw ur lr 150)
           (grdraw lr ll 150)))
 (list ll ul ur lr))
 ; Ŀ
 ;   Tbx end.                                                              
 ; 

 ; Ŀ
 ;   Bn - because there is no bn command yet.                              
 ; 
 (DEFUN C:BN (/ osmo snapp *error* tenam tent linpts lina linb ptlist ll ul
                         ur lr txmid tangle cmid txtop txbas pint rad pa anga)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "snapmode" snapp)
   (command ".undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get a text entity.                                                    
 ; 
  (if (and (setq tenam (entsel "Text: "))
           (setq tenam (car tenam))
           (setq tent (entget tenam))
           (= "TEXT" (cdr (assoc 0 tent)))
 ; Ŀ
 ;   Call Pspt to get two points on a line either in ps or ms, in units    
 ;   reflecting their current position as it appears in paper space,       
 ;   unless we are already in model space, in which case they are          
 ;   returned as is.                                                       
 ; 
           (setq linpts (pspt))
           (setq lina (car linpts))
           (setq linb (cadr linpts)))
      (progn
 ; Ŀ
 ;   Find the corner points of the entity.                                 
 ; 
           (setq ptlist (tbx tenam))
           (setq ll (car ptlist))
           (setq ul (cadr ptlist))
           (setq ur (caddr ptlist))
           (setq lr (cadddr ptlist))
 ; Ŀ
 ;   Get the text midpoint point and angle and a point on a line at a      
 ;   right angle to the text.                                              
 ; 
           (setq txmid (polar ll (angle ll ur) (/ (distance ll ur) 2)))
           (setq tangle (cdr (assoc 50 tent)))
           (setq cmid (polar txmid (+ tangle (/ pi 2)) 10)) ; theoretical endpt
 ; Ŀ
 ;   Get the text top and base midpoints.                                  
 ; 
           (setq txtop (polar ul (angle ul ur) (/ (distance ul ur) 2)))
           (setq txbas (polar ll (angle ll lr) (/ (distance ll lr) 2)))
 ; Ŀ
 ;   Find the intersection of the line and one perpendicular to the text.  
 ; 
           (setq pint (inters txmid cmid lina linb ()))
           (setq rad (/ (getvar "viewsize") 100))
           (cstar pint rad 0 7)
 ; Ŀ
 ;   Find a point 1.5 units away from the line towards the text.           
 ; 
           (setq pa (polar txmid (setq anga (angle txmid pint))
                                (- (distance pint txmid) 1.5)))
 ; Ŀ
 ;   Move the text.                                                        
 ; 
           (if (equal anga (+ tangle (/ pi 2)) 0.01)
               (command ".move" tenam "" txtop pa)
               (command ".move" tenam "" txbas pa))))
  (*error* ())
 (princ))